<?php
  BEvent::HookInstanceOf('CommentSidebar', 'Generate', 'sidebars: generate: comments');
  BaseSidebar::InstallationConfShortcuts();

/* one-shot */
  $this->name = 'comment sidebar';
  $this->Caption('Боковая панель с комментариями', 'ru');
/* install CommentSidebar */
class CommentSidebar extends BaseSidebar {
  public $type = 'comments';

  public $selector, $selected = array();
  public $allAuthors = array(), $byPostAuthors = array();
  public $totalComments, $curComment;

  function DoGenerate() {
    $this->selector = $this->config['selector'];
    $this->totalComments = BComments::Total();

    $comments = $this->SelectAll();
    $this->Prepare($comments);

    return $comments;
  }

    function NormalizeSidebar() {
      $this->info += array('icon16' => BConfig::$staticURL.'comment-sidebar-16.png',
                           'icon24' => BConfig::$staticURL.'comment-sidebar-24.png',
                           'icon32' => BConfig::$staticURL.'comment-sidebar-32.png',
                           'caption' => 'Latest comments');
    }

    function SelectAll() {
      $comments = $byPost = array();
      $comment = true;

        while (!isset( $comments[$this->config['max comments'] - 1] )) {
          $path = $this->SelectOne();

            while ($path) {
              $byPostCount = &$byPost[BComments::PostOf($path)];
              if ($byPostCount < $this->config['max per post']) {
                break;
              }

              $path = $this->SelectOne();
            }

          if (!$path) {
            break;
          }

          $comment = $this->GetComment($path);

          if ($comment and $this->CanShow($comment, $comments)) {
            $comments[] = $comment;
            ++$byPostCount;
          }
        }

      return $comments;
    }

      function GetComment($path) {
        $post = BComments::PostOf($path);
        $postURL = BPosts::UrlOf($post);
        $postTitle = BPosts::TitleOf($post, true);
        $commentURL = BComments::UrlOf($path);

        return BComments::Get($path) + compact('post', 'postURL', 'postTitle', 'commentURL');
      }

      function SelectOne() {
        $cur = &$this->curComment;

        if ($cur === null) {
          switch ($this->selector) {
          case 'first':   $cur = BComments::First(); break;
          case 'latest':  $cur = BComments::Last(); break;
          }
        } else {
          switch ($this->selector) {
          case 'first':     $cur = BComments::NextTo($cur); break;
          case 'latest':    $cur = BComments::PreviousTo($cur); break;
          }
        }

        if ($this->selector === 'random') {
          do {
            if (count($this->selected) >= $this->totalComments) {
              return null;
            }

            $cur = BComments::Random();
          } while (isset($this->selected[$cur]));

          $this->selected[$cur] = true;
        }

        return $cur;
      }

    function CanShow(array &$comment, array &$comments) {
      return $this->CanShowByCommenter($comment) and
             $this->CanShowByInfo($comment);
    }

      function CanShowByCommenter(array &$comment) {
        if (!$comment['isByAnonymous'] or BConfig::ToBool($this->config['treat anons as one'])) {
          $maxPerPost = $comment['isByPostAuthor'] ? $this->config['max by post author'] : null;
          $perPostAuthors = &$this->byPostAuthors[ $comment['post'] ];

          if ((!$this->CheckByCommenter($comment, 'all', $this->allAuthors) or
              !$this->CheckByCommenter($comment, 'post', $perPostAuthors, $maxPerPost))) {
            return false;
          }
        }

        return true;
      }

        function CheckByCommenter(array &$comment, $perWhich, &$store, $max = null) {
          $max or $max = $this->config['max by commenter per '.$perWhich];
          if ($max) {
            $count = &$store[ $comment['author'] ];
            if ($count === null) {
              $count = 0;
            } elseif ($count >= $max) {
              return false;
            }

            ++$count;
          }

          return true;
        }

      function CanShowByInfo(array &$comment) {
        if ($comment['isByPostAuthor'] and BConfig::ToBool($this->config['hide by author'])) {
          return false;
        }

        if ($comment['isByAnonymous'] and BConfig::ToBool($this->config['hide by anonymous'])) {
          return false;
        }

        if ($users = &$this->config['hide by users']) {
          if (!is_array($users)) {
            $users = explode(',', $users);
            foreach ($users as &$user) { $user = trim($user); }
            $users = array_flip(array_unique($users));
          }

          $allBut = isset($users['*']);
          $hasUser = isset($users[$comment['author']]);
          if ($allBut ? !$hasUser : $hasUser) {
            return false;
          }
        }

        if ($ips = &$this->config['hide by ips']) {
          if (!is_array($ips)) {
            $ips = explode(' ', $ips);
            $ips = array_flip(array_unique(array_filter($ips)));
          }

          $allbut = isset($ips['*']);
          $hasIP = isset($ips[$comment['ip']]);

            if (!$hasIP) {
              foreach ($ips as $ip) {
                if ($hasIP = MatchWildcardIP($ip, $comment['ip'])) { break; }
              }
            }

          if ($allbut ? !$hasIP : $hasIP) {
            return false;
          }
        }

        return true;
      }

    function Prepare(array &$comments) {
      if (strpos(' '.$this->config['fields'].' ', ' text ') !== false) {
        foreach ($comments as &$comment) {
          $comment['text'] = $this->Shorten($comment['source'], $comment['formatter']);
        }
      }

      $this->FilterFieldsIn($comments, $this->config['fields']);
      BComments::SortAs($this->config['sort'], $comments);
    }

      function FilterFieldsIn(array &$comments, $fields) {
        is_array($fields) or $fields = explode(' ', $fields);

        $pfFields = array();

          foreach ($fields as &$field) {
            if (substr($field, -1) === '*') {
              $pfFields[] = substr($field, 0, -1);
              $field = '';
            }
          }

          $fields = array_flip($fields);

        foreach ($comments as &$comment) {
          $pf = array();

            foreach ($comment as $field => &$value) {
              $found = false;

                foreach ($pfFields as $pfField) {
                  if (strpos($field, $pfField) === 0) {
                    $found = true;
                    break;
                  }
                }

               $found and $pf[$field] = &$value;
             }

          $comment = array_intersect_key($comment, $fields) + $pf;
        }
      }

      function Shorten(&$source, $markup) {
        static $pf = 'shorten ';
        $options = array();

          foreach ($this->config as $key => $value) {
            if (strpos($key, $pf) === 0) {
              $options[ substr($key, strlen($pf)) ] = $value;
            }
          }

        if (BConfig::ToBool($this->config['format']) and $markup === 'wiki') {
          $doc = BUverseWiki::Format($source);
          return ShortenInlineDoc($doc, $options);
        } else {
          return htmlspecialchars8( ShortenInlineText($source, $options) );
        }
      }
}

/* one-shot */
return;
?>

/* install config/sidebars/comments.conf */
cache = yes
regenerate on events = comment added, comment deleted, comment moved, comment updated

== Latest comments ==
# if enabled, comments using wiki formatter will retain their formatting when shortened;
# otherwise comments' raw source text will shortened and then have HTML chars escaped.
format = yes

#=shortener

# hides comments made by the article author.
hide by author = off
# hides comments made by anonymous commenters (with no user name).
hide by anonymous = off
# comma-separated list of commenter names to hide from the sidebar; if first or last name
# is '*' (asterisk) then all but listed users are hidden, otherwise only listed are hidden.
hide by users =
# space-separated list of IP addresses; if any IP is '*' works similar to 'hide by users';
# IP octets can contain '*' to match any octet in that positions (e.g. '192.168.*.*').
hide by ips =

# max comments shown on the sidebar.
max comments = 15
# max comments shown per each article.
max per post = 4
# each user will have no more than this number of his/her comments shown on the sidebar;
max by commenter per all = 8
# similar to the above but limits his/her comments displayed in regards to a single article;
max by commenter per post = 3
# comments by post authors are unaffected by 'max by commenter ...'; this setting
# restricts number of such comments per each post but is only for article author comments.
max by post author = 10
# if disabled anonymous commenters are NOT affected by 'max by commenter ...' settings.
treat anons as one = yes

# sorting of comments; allows the same values as 'comment sorting' from other.conf.
sort = TimeDesc
# space-separated list of info fields shown about each comment; trailing '*' matches
# any field starting with given string (case-sensitive).
fields = text author authorHome time avatar* postURL postTitle commentURL isByPostAuthor isByAnonymous
# the source of comment records; values: 'latest' (starts from most recent comments
# until the needed count is gathered), 'first' (from the first blog comment ever),
# 'random' (each sidebar regeneration picks random comments).
selector = latest

/* install base64:static/comment-sidebar-16.png */
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADVElEQVR4XmXMS2xUZRjG8f935lxm
5kynTWstt1paMLRWJRolxAChiBFNJILxujHGjRtjosbYDRIXeDfIQhM1IW5cqA1dqIlpYkzYAIoE
21BKaYHSTjvtTGemc+bcz/c5C7vyyfvkeVc/MXLhVeYLsyRxjBdUMnd2tR/q7u59VBeZzYalWu0W
a9WNyuPVYGbEj/0JnRZAsh5dCIEgheMtHNq2ve/DXQMv7rTNDSgtJJIecezTokfPZFN9b8/Vf3/f
D6ufCFKIdcD3Pdxg5YXBwfu/G9r5pukEBerxTaLEw0tWWAtv40XLJFLmoiT+2I/q0wbmqFoHCss3
t+Ty6VP77nvDLLmTBHGNWjDLsn8JJ7iNUmGzEikhlgIZpZ+NEzkapwIQoJerSwf39x/tbERFKu4s
BfccZe8KSiVYQidjGJiWREnVBAO8IF3PNXrYWNuB0bDQpUxpSSIouVe5VvmZWjCPjkE6ZZC3NexA
I7rYAasbMbMWkdNR3VrfZfRmBqJ0sQlk7fzYP1Pnlu627Q0ldw6kgRCCdBb02RzuT3vYPniU7nsH
MC0L6QVv+avLB2W5Puwb0Zj4dHQvxfLiY5k29XXblnirECkM3aMLHfHFE+x7/h06e9uJaw1UI0TV
fZQbk5QdN6l4+8UHI4/gRqsUlkodoP3wwO6+A4F1A+N8++TuxWMDDx85QLBYQa40kMU6hAkogQpi
lBe9p03dus6thTLVcmKji/41tUjhhjo1+VvrkFRynkIdObVCfHkRVfYQWGhGC8IVzUZ/6049REny
mTYxbHfJC3/9Wv1+fFSdWZm7LKfGP3/928zxk90Loke5Aal8K2g6ca3mhLXyyaTF+IWn3s1zeDiv
P3ei1d77so2V1UygC9gEtPd0buo//tBLr02/cvqbiSNf/Vg6fNqdf/zLE2ef/IizT3+GrmmgJPHM
+TCuFRMUygQCQGWNdOI77vSfldmr7rUxpBOwbfNde3aErQ9Orc7bxaTe0AGSSFGciZoLmqYaWgp0
YdCWtlV3rpOSU+HM+B/msl81GxPhxZyevjR0xz2RmTLQARCQMgQyUajmAQhAKcWV8hxO5GnNPwsY
gKomTnC9UYzbTPs/4P9BCMFa4NKIfAAFOOuuBkmCVAL4F1NKwSlf0KRHAAAAAElFTkSuQmCC

/* install base64:static/comment-sidebar-24.png */
iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAFfElEQVR4XqWRfWxdZR3HP89zXu7p
7b3ldmvXTka30bqNlc6yDQcN6DLF4DYWA/gSjYoYI0hRwQTjyEiYohGjJmhIDKAxMTFGjMYQERNN
lDBIRUTTCAxCme269fXe3t57z+vz/Dxp7h9dIP6zb/LJL+f88f2cb4760sPdAChFjgLAZkKhlHU5
XnrN9ivKo57T1VvwuvorG4puRzmbD5P62ZSVU6mNJ5BCkmWaJLVkhrfFpR0UiECWpUOVXnPX8Mjw
rbu33bBlU2k/pUIfKMhMmhOSmhYNM8VC/I/JudYL37M0fwGeBXlnAQqsUa5yo3tHDmw6ccPV95QG
SodJTEQjnaYWvUlmQ4ykCAaFi0s3W4Kbriw7u34+Vf/9h2vp2c+Dbr2jwBpc7Yc/GTt4xe1Hr/oR
junjfHOC2FZBBEFBTmYTErNKmM0RmeraEoVHoC79hGLxvJDco1AXCqyAlfTBfQe2337sqseIE8Ns
9DQIoDQiQmQWqcWnWU3P0ErnSW0La7McixVAPKyo2zLDEyCTFwjSxO7tHdBf/eDocUxW4Hz4RxQe
IoownWUxfJlq/AqxWUWjctwcneMhSmHFYoDMSCXN2E0usFiMTnIyXCPZ4YHLdhZ7inuZWXkWYyxG
Gnnxv5kLJ0iy1TWho3wcFK7WOIo1mSBYrcnLMQKJSi3a4sVFLq++l77qEK5VWV93aTtRukIrXSQx
TaYbf6EavQE4aOWjRKG1oqA1BSe/BYVXsEgqJKGQKsuSNGfD14OXrpw6ygc2foZgMcBv+LhZqhdq
9WUSu8JqMp+X/5V6PI3GB1GgwG2Xd3YoSoHCvFVkdaILe64XT2+kc0OR3s7lVvCMv22zc+1M5+Hu
JFNNIq+OtsZ96rXXX23M1V/hbOMFlptnsMYnzVibjlW4KIqB0BEWmP/hEOePH2Lz+a9x3dgPOHTs
Ya6//iS37n5k6FN3PvDnoSO7/x5LfLNgAVCffKBCksb37T/wnu8ODHvM1V/FGoWI4CqHDs+h0qm4
JOlg4ZvDdEfv57rjN3PJQA9SDbHNGJsZsIJCwIBZbmL+W3uERvIV9dHjXYgFsHcMjfR/p2cwrQR+
CZNlWGlQ9IS+DYrwiR34zx7iyGN3UNAu6WwNEQErkJhclJAXIlGKZBbyZ6lFn1Mfu78LAGuEOLFb
Orrcr2/d1TW+Z3gvS81JHHeVIAusnNyv33fTODsP7yM5PQcKJLHIcgu70IRWgghgBYxF0pwwedKN
EgDaP9SZqc6nz3f3mfFqdJZW1iAVM1n/l7p7T73voe6tPWNmuobkZRIZ7JkashIiGpTnroGjQQNp
jF2NIzeKBQAFiJVt5Y3+ic1DndTSWaLY/Of5J8NPn3q89vKd/W/+8uDs0phWRWw1ysuX1y6OQnse
ys2hgHJcEMhqK0gz/o2rFACIZU+51/nVjrHCrtCuvHHupfhnT3+/+ejCVFYD/B9PP/PTnl9v3fmN
2+4e92eaROcaiFiU44AqoKyPygKklWFmz2GXFk+KUr9TH/pyCRHwArV/26h3+elTyeSLvw3fqs+Z
ljUEQAnQ7ZXJF278+EfGB2/84mCtY9SzOsiURpc60U6BuNnErFRPJXHrocAv/KHsFVFH7iuDAq3h
9HMJr/0tBnCBCuBzYSyKlu96+tiWqwfuuuWz1ww4Gy8NJ6bSWNJbdro9o77VJ/7ZnPnWt6efYqRr
AAYP+Lx7zKdvyGVd/LagZx0b2tIS4GrfZce+Efovexcuik3l7sqf7n30waWjjz/34p4TBwPt8f+i
2yv8dbiAbkMb3cYHdLFSphx0Vq4tD/Z3aF9zkWkXU1y3dlN7abEtxr1IQREI1q2y6+/FCiwQAdmF
78jaWADFxUWvu2/7eoD/AVIaucix+wMaAAAAAElFTkSuQmCC

/* install base64:static/comment-sidebar-32.png */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